/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy.lucene;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.DlsFlsComplianceConfig;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.MaskedField;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.lucene.MapUtils;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.SgUtils;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchsupport.dfm.MaskedFieldsConsumer;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

class DlsFlsFilterLeafReader
extends SequentialStoredFieldsLeafReader {
    private static final Logger log = LogManager.getLogger(DlsFlsFilterLeafReader.class);
    private static final String KEYWORD = ".keyword";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Set<String> includesSet;
    private final Set<String> excludesSet;
    private final FieldInfos flsFieldInfos;
    private final boolean flsEnabled;
    private String[] includes;
    private String[] excludes;
    private boolean canOptimize = true;
    private Function<Map<String, ?>, Map<String, Object>> filterFunction;
    private final IndexService indexService;
    private final ThreadContext threadContext;
    private final DlsFlsComplianceConfig complianceConfig;
    private final Map<String, MaskedField> maskedFieldsMap;
    private final Set<String> maskedFieldsKeySet;
    private final boolean maskFields;
    private final boolean localHashingEnabled;
    private DlsGetEvaluator dge = null;
    private final MapUtils.Callback HASH_CB = new HashingCallback();

    DlsFlsFilterLeafReader(LeafReader delegate, Set<String> includesExcludes, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, DlsFlsComplianceConfig complianceConfig, AuditLog auditlog, Set<String> maskedFields, ShardId shardId) {
        super(delegate);
        try {
            this.maskFields = complianceConfig != null && complianceConfig.isEnabled() && maskedFields != null && maskedFields.size() > 0;
            this.localHashingEnabled = complianceConfig != null && complianceConfig.isLocalHashingEnabled();
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.complianceConfig = complianceConfig;
            this.maskedFieldsMap = this.maskFields ? this.extractMaskedFields(maskedFields) : null;
            this.maskedFieldsKeySet = this.maskedFieldsMap != null ? this.maskedFieldsMap.keySet() : null;
            boolean bl = this.flsEnabled = includesExcludes != null && !includesExcludes.isEmpty();
            if (this.flsEnabled) {
                FieldInfos infos = delegate.getFieldInfos();
                this.includesSet = new HashSet<String>(includesExcludes.size());
                this.excludesSet = new HashSet<String>(includesExcludes.size());
                for (String incExc : includesExcludes) {
                    char firstChar;
                    if (this.canOptimize && (incExc.indexOf(46) > -1 || incExc.indexOf(42) > -1)) {
                        this.canOptimize = false;
                    }
                    if ((firstChar = incExc.charAt(0)) == '!' || firstChar == '~') {
                        this.excludesSet.add(incExc.substring(1));
                        continue;
                    }
                    this.includesSet.add(incExc);
                }
                int i = 0;
                FieldInfo[] fa = new FieldInfo[infos.size()];
                if (this.canOptimize) {
                    if (!this.excludesSet.isEmpty()) {
                        for (FieldInfo info : infos) {
                            if (this.excludesSet.contains(info.name)) continue;
                            fa[i++] = info;
                        }
                    } else {
                        for (String inc : this.includesSet) {
                            FieldInfo f = infos.fieldInfo(inc);
                            if (f == null) continue;
                            fa[i++] = f;
                        }
                    }
                } else {
                    if (!this.excludesSet.isEmpty()) {
                        for (FieldInfo info : infos) {
                            if (WildcardMatcher.matchAny(this.excludesSet, (String)info.name)) continue;
                            fa[i++] = info;
                        }
                        this.excludes = this.excludesSet.toArray(EMPTY_STRING_ARRAY);
                    } else {
                        for (FieldInfo info : infos) {
                            if (!WildcardMatcher.matchAny(this.includesSet, (String)info.name)) continue;
                            fa[i++] = info;
                        }
                        this.includes = this.includesSet.toArray(EMPTY_STRING_ARRAY);
                    }
                    this.filterFunction = !this.excludesSet.isEmpty() ? XContentMapValues.filter(null, (String[])this.excludes) : XContentMapValues.filter((String[])this.includes, null);
                }
                FieldInfo[] tmp = new FieldInfo[i];
                System.arraycopy(fa, 0, tmp, 0, i);
                this.flsFieldInfos = new FieldInfos(tmp);
            } else {
                this.includesSet = null;
                this.excludesSet = null;
                this.flsFieldInfos = null;
            }
            this.dge = new DlsGetEvaluator(dlsQuery, this.in, this.applyDlsHere());
        }
        catch (RuntimeException e) {
            log.error("Got exception while initializing " + (Object)((Object)this), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("Got exception while initializing " + (Object)((Object)this), (Throwable)e);
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    private Map<String, MaskedField> extractMaskedFields(Set<String> maskedFields) {
        HashMap<String, MaskedField> retVal = new HashMap<String, MaskedField>(maskedFields.size());
        for (String mfs : maskedFields) {
            MaskedField mf = new MaskedField(mfs, this.complianceConfig.getSalt16(), this.localHashingEnabled ? this.complianceConfig.getSalt2_16() : null, this.complianceConfig.getMaskPrefix());
            retVal.put(mf.getName(), mf);
        }
        return retVal;
    }

    public void document(int docID, StoredFieldVisitor visitor) throws IOException {
        if (this.flsEnabled) {
            this.in.document(docID, (StoredFieldVisitor)new FlsStoredFieldVisitor(this.maskFields ? new HashingStoredFieldVisitor(visitor) : visitor));
        } else {
            this.in.document(docID, (StoredFieldVisitor)(this.maskFields ? new HashingStoredFieldVisitor(visitor) : visitor));
        }
    }

    private boolean isFls(BytesRef termAsFiledName) {
        return this.isFls(termAsFiledName.utf8ToString());
    }

    private boolean isFls(String name) {
        if (!this.flsEnabled) {
            return true;
        }
        return this.flsFieldInfos.fieldInfo(name) != null;
    }

    public FieldInfos getFieldInfos() {
        if (!this.flsEnabled) {
            return this.in.getFieldInfos();
        }
        return this.flsFieldInfos;
    }

    public Fields getTermVectors(int docID) throws IOException {
        final Fields fields = this.in.getTermVectors(docID);
        if (!this.flsEnabled || fields == null) {
            return fields;
        }
        return new Fields(){

            public Iterator<String> iterator() {
                return Iterators.filter((Iterator)fields.iterator(), (Predicate)new Predicate<String>(){

                    public boolean apply(String input) {
                        return DlsFlsFilterLeafReader.this.isFls(input);
                    }
                });
            }

            public Terms terms(String field) throws IOException {
                if (!DlsFlsFilterLeafReader.this.isFls(field)) {
                    return null;
                }
                return DlsFlsFilterLeafReader.this.wrapTerms(field, DlsFlsFilterLeafReader.this.in.terms(field));
            }

            public int size() {
                return DlsFlsFilterLeafReader.this.flsFieldInfos.size();
            }
        };
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getNumericDocValues(field) : null;
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        return this.isFls(field) ? this.wrapBinaryDocValues(field, this.in.getBinaryDocValues(field)) : null;
    }

    private BinaryDocValues wrapBinaryDocValues(String field, final BinaryDocValues binaryDocValues) {
        String matchedPattern;
        Map<String, MaskedField> rtMask;
        if (binaryDocValues != null && (rtMask = this.getRuntimeMaskedFieldInfo()) != null && (matchedPattern = (String)WildcardMatcher.getFirstMatchingPattern(rtMask.keySet(), (String)this.handleKeyword(field)).orElse(null)) != null) {
            final MaskedField mf = rtMask.get(matchedPattern);
            if (mf == null) {
                return binaryDocValues;
            }
            return new BinaryDocValues(){

                public int nextDoc() throws IOException {
                    return binaryDocValues.nextDoc();
                }

                public int docID() {
                    return binaryDocValues.docID();
                }

                public long cost() {
                    return binaryDocValues.cost();
                }

                public int advance(int target) throws IOException {
                    return binaryDocValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return binaryDocValues.advanceExact(target);
                }

                public BytesRef binaryValue() throws IOException {
                    return mf.mask(binaryDocValues.binaryValue());
                }
            };
        }
        return binaryDocValues;
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        return this.isFls(field) ? this.wrapSortedDocValues(field, this.in.getSortedDocValues(field)) : null;
    }

    private SortedDocValues wrapSortedDocValues(String field, final SortedDocValues sortedDocValues) {
        String matchedPattern;
        Map<String, MaskedField> rtMask;
        if (sortedDocValues != null && (rtMask = this.getRuntimeMaskedFieldInfo()) != null && (matchedPattern = (String)WildcardMatcher.getFirstMatchingPattern(rtMask.keySet(), (String)this.handleKeyword(field)).orElse(null)) != null) {
            final MaskedField mf = rtMask.get(matchedPattern);
            if (mf == null) {
                return sortedDocValues;
            }
            return new SortedDocValues(){

                public BytesRef binaryValue() throws IOException {
                    return mf.mask(sortedDocValues.binaryValue());
                }

                public int lookupTerm(BytesRef key) throws IOException {
                    return sortedDocValues.lookupTerm(key);
                }

                public TermsEnum termsEnum() throws IOException {
                    return new MaskedTermsEnum(sortedDocValues.termsEnum(), mf);
                }

                public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                    return new MaskedTermsEnum(sortedDocValues.intersect(automaton), mf);
                }

                public int nextDoc() throws IOException {
                    return sortedDocValues.nextDoc();
                }

                public int docID() {
                    return sortedDocValues.docID();
                }

                public long cost() {
                    return sortedDocValues.cost();
                }

                public int advance(int target) throws IOException {
                    return sortedDocValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return sortedDocValues.advanceExact(target);
                }

                public int ordValue() throws IOException {
                    return sortedDocValues.ordValue();
                }

                public BytesRef lookupOrd(int ord) throws IOException {
                    return mf.mask(sortedDocValues.lookupOrd(ord));
                }

                public int getValueCount() {
                    return sortedDocValues.getValueCount();
                }
            };
        }
        return sortedDocValues;
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getSortedNumericDocValues(field) : null;
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        return this.isFls(field) ? this.wrapSortedSetDocValues(field, this.in.getSortedSetDocValues(field)) : null;
    }

    private SortedSetDocValues wrapSortedSetDocValues(String field, final SortedSetDocValues sortedSetDocValues) {
        String matchedPattern;
        Map<String, MaskedField> rtMask;
        if (sortedSetDocValues != null && (rtMask = this.getRuntimeMaskedFieldInfo()) != null && (matchedPattern = (String)WildcardMatcher.getFirstMatchingPattern(rtMask.keySet(), (String)this.handleKeyword(field)).orElse(null)) != null) {
            final MaskedField mf = rtMask.get(matchedPattern);
            if (mf == null) {
                return sortedSetDocValues;
            }
            return new SortedSetDocValues(){

                public long lookupTerm(BytesRef key) throws IOException {
                    return sortedSetDocValues.lookupTerm(key);
                }

                public TermsEnum termsEnum() throws IOException {
                    return new MaskedTermsEnum(sortedSetDocValues.termsEnum(), mf);
                }

                public TermsEnum intersect(CompiledAutomaton automaton) throws IOException {
                    return new MaskedTermsEnum(sortedSetDocValues.intersect(automaton), mf);
                }

                public int nextDoc() throws IOException {
                    return sortedSetDocValues.nextDoc();
                }

                public int docID() {
                    return sortedSetDocValues.docID();
                }

                public long cost() {
                    return sortedSetDocValues.cost();
                }

                public int advance(int target) throws IOException {
                    return sortedSetDocValues.advance(target);
                }

                public boolean advanceExact(int target) throws IOException {
                    return sortedSetDocValues.advanceExact(target);
                }

                public long nextOrd() throws IOException {
                    return sortedSetDocValues.nextOrd();
                }

                public BytesRef lookupOrd(long ord) throws IOException {
                    return mf.mask(sortedSetDocValues.lookupOrd(ord));
                }

                public long getValueCount() {
                    return sortedSetDocValues.getValueCount();
                }
            };
        }
        return sortedSetDocValues;
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getNormValues(field) : null;
    }

    public PointValues getPointValues(String field) throws IOException {
        return this.isFls(field) ? this.in.getPointValues(field) : null;
    }

    public Terms terms(String field) throws IOException {
        return this.isFls(field) ? this.wrapTerms(field, this.in.terms(field)) : null;
    }

    private Terms wrapTerms(String field, Terms terms) throws IOException {
        if (terms == null) {
            return null;
        }
        try {
            Map<String, MaskedField> rtMask = this.getRuntimeMaskedFieldInfo();
            if (!this.localHashingEnabled && rtMask != null && WildcardMatcher.matchAny(rtMask.keySet(), (String)this.handleKeyword(field))) {
                return null;
            }
            if ("_field_names".equals(field)) {
                return new FilteredTerms(terms);
            }
            return terms;
        }
        catch (RuntimeException e) {
            log.error("Got exception in wrapTerms(" + field + ")", (Throwable)e);
            throw e;
        }
    }

    public Bits getLiveDocs() {
        return this.dge.getLiveDocs();
    }

    public int numDocs() {
        return this.dge.numDocs();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.dge.getReaderCacheHelper();
    }

    public boolean hasDeletions() {
        return this.dge.hasDeletions();
    }

    private Map<String, MaskedField> getRuntimeMaskedFieldInfo() {
        Set mf;
        if (this.complianceConfig == null || !this.complianceConfig.isEnabled()) {
            return null;
        }
        Map maskedFieldsMap = (Map)((Object)HeaderHelper.deserializeSafeFromHeader((ThreadContext)this.threadContext, (String)"_sg_masked_fields"));
        String maskedEval = SgUtils.evalMap((Map)maskedFieldsMap, (String)this.indexService.index().getName());
        if (maskedEval != null && (mf = (Set)maskedFieldsMap.get(maskedEval)) != null && !mf.isEmpty()) {
            return this.extractMaskedFields(mf);
        }
        return null;
    }

    private String handleKeyword(String field) {
        if (field != null && field.endsWith(KEYWORD)) {
            return field.substring(0, field.length() - KEYWORD.length());
        }
        return field;
    }

    private String getRuntimeActionName() {
        return (String)this.threadContext.getTransient("_sg_action_name");
    }

    private boolean isSuggest() {
        return this.threadContext.getTransient("_sg_issuggest") == Boolean.TRUE;
    }

    private boolean applyDlsHere() {
        if (this.isSuggest()) {
            return true;
        }
        String action = this.getRuntimeActionName();
        assert (action != null);
        return !action.startsWith("indices:data/read/search");
    }

    protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
        return new SearchGuardStoredFieldsReader(reader);
    }

    private static class MaskedTermsEnum
    extends TermsEnum {
        private final TermsEnum delegate;
        private final MaskedField mf;

        public MaskedTermsEnum(TermsEnum delegate, MaskedField mf) {
            this.delegate = delegate;
            this.mf = mf;
        }

        public BytesRef next() throws IOException {
            return this.delegate.next();
        }

        public AttributeSource attributes() {
            return this.delegate.attributes();
        }

        public boolean seekExact(BytesRef text) throws IOException {
            return this.delegate.seekExact(text);
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.delegate.seekCeil(text);
        }

        public void seekExact(long ord) throws IOException {
            this.delegate.seekExact(ord);
        }

        public void seekExact(BytesRef term, TermState state) throws IOException {
            this.delegate.seekExact(term, state);
        }

        public BytesRef term() throws IOException {
            return this.mf.mask(this.delegate.term());
        }

        public long ord() throws IOException {
            return this.delegate.ord();
        }

        public int docFreq() throws IOException {
            return this.delegate.docFreq();
        }

        public long totalTermFreq() throws IOException {
            return this.delegate.totalTermFreq();
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return this.delegate.postings(reuse, flags);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            return this.delegate.impacts(flags);
        }

        public TermState termState() throws IOException {
            return this.delegate.termState();
        }
    }

    private final class FilteredTerms
    extends FilterLeafReader.FilterTerms {
        public FilteredTerms(Terms delegate) throws IOException {
            super(delegate);
        }

        public TermsEnum iterator() throws IOException {
            return new FilteredTermsEnum(this.in.iterator());
        }
    }

    private final class FilteredTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        public FilteredTermsEnum(TermsEnum delegate) {
            super(delegate);
        }

        public BytesRef next() throws IOException {
            BytesRef nextBytesRef = this.in.next();
            while (nextBytesRef != null) {
                if (DlsFlsFilterLeafReader.this.isFls(nextBytesRef)) {
                    return nextBytesRef;
                }
                nextBytesRef = this.in.next();
            }
            return null;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            TermsEnum.SeekStatus delegateStatus = this.in.seekCeil(text);
            if (delegateStatus != TermsEnum.SeekStatus.END && DlsFlsFilterLeafReader.this.isFls(this.in.term())) {
                return delegateStatus;
            }
            if (delegateStatus == TermsEnum.SeekStatus.END) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }

        public boolean seekExact(BytesRef term) throws IOException {
            return DlsFlsFilterLeafReader.this.isFls(term) && this.in.seekExact(term);
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class SearchGuardStoredFieldsReader
    extends StoredFieldsReader {
        private final StoredFieldsReader delegate;

        public SearchGuardStoredFieldsReader(StoredFieldsReader delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public long ramBytesUsed() {
            return this.delegate.ramBytesUsed();
        }

        public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
            try {
                if (DlsFlsFilterLeafReader.this.maskFields) {
                    visitor = new HashingStoredFieldVisitor(visitor);
                }
                if (DlsFlsFilterLeafReader.this.flsEnabled) {
                    visitor = new FlsStoredFieldVisitor(visitor);
                }
                this.delegate.visitDocument(docID, visitor);
            }
            catch (RuntimeException e) {
                log.error("Error in SearchGuardStoredFieldsReader.visitDocument()", (Throwable)e);
                throw e;
            }
        }

        public StoredFieldsReader clone() {
            return new SearchGuardStoredFieldsReader(this.delegate);
        }

        public void checkIntegrity() throws IOException {
            this.delegate.checkIntegrity();
        }
    }

    private class HashingCallback
    implements MapUtils.Callback {
        private HashingCallback() {
        }

        @Override
        public void call(String key, Map<String, Object> map, List<String> stack) {
            Optional matchedPattern;
            String field;
            Object v = map.get(key);
            if (v != null && v instanceof List) {
                field = stack.isEmpty() ? key : Joiner.on((char)'.').join(stack) + "." + key;
                matchedPattern = WildcardMatcher.getFirstMatchingPattern((Collection)DlsFlsFilterLeafReader.this.maskedFieldsKeySet, (String)field);
                if (matchedPattern.isPresent()) {
                    List listField = (List)v;
                    ListIterator<Object> iterator = listField.listIterator();
                    while (iterator.hasNext()) {
                        Object listFieldItem = iterator.next();
                        if (listFieldItem instanceof String) {
                            iterator.set(((MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.get(matchedPattern.get())).mask((String)listFieldItem));
                            continue;
                        }
                        if (!(listFieldItem instanceof byte[])) continue;
                        iterator.set(((MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.get(matchedPattern.get())).mask((byte[])listFieldItem));
                    }
                }
            }
            if (v != null && (v instanceof String || v instanceof byte[])) {
                field = stack.isEmpty() ? key : Joiner.on((char)'.').join(stack) + "." + key;
                matchedPattern = WildcardMatcher.getFirstMatchingPattern((Collection)DlsFlsFilterLeafReader.this.maskedFieldsKeySet, (String)field);
                if (matchedPattern.isPresent()) {
                    if (v instanceof String) {
                        map.replace(key, ((MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.get(matchedPattern.get())).mask((String)v));
                    } else {
                        map.replace(key, ((MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.get(matchedPattern.get())).mask((byte[])v));
                    }
                }
            }
        }
    }

    private class HashingStoredFieldVisitor
    extends StoredFieldVisitor {
        private final StoredFieldVisitor delegate;

        public HashingStoredFieldVisitor(StoredFieldVisitor delegate) {
            this.delegate = delegate;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            if (fieldInfo.name.equals("_source")) {
                BytesArray bytesRef = new BytesArray(value);
                Tuple bytesRefTuple = XContentHelper.convertToMap((BytesReference)bytesRef, (boolean)false, (XContentType)XContentType.JSON);
                Map filteredSource = (Map)bytesRefTuple.v2();
                MapUtils.deepTraverseMap(filteredSource, DlsFlsFilterLeafReader.this.HASH_CB);
                XContentBuilder xBuilder = XContentBuilder.builder((XContent)((XContentType)bytesRefTuple.v1()).xContent()).map(filteredSource);
                if (this.delegate instanceof MaskedFieldsConsumer) {
                    ((MaskedFieldsConsumer)this.delegate).binaryMaskedField(fieldInfo, BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)xBuilder)), f -> DlsFlsFilterLeafReader.this.maskedFieldsKeySet != null && WildcardMatcher.getFirstMatchingPattern((Collection)DlsFlsFilterLeafReader.this.maskedFieldsKeySet, (String)f).isPresent());
                } else {
                    this.delegate.binaryField(fieldInfo, BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)xBuilder)));
                }
            } else {
                this.delegate.binaryField(fieldInfo, value);
            }
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.delegate.needsField(fieldInfo);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            Optional matchedPattern = WildcardMatcher.getFirstMatchingPattern((Collection)DlsFlsFilterLeafReader.this.maskedFieldsKeySet, (String)fieldInfo.name);
            if (matchedPattern.isPresent()) {
                if (this.delegate instanceof MaskedFieldsConsumer) {
                    ((MaskedFieldsConsumer)this.delegate).stringMaskedField(fieldInfo, ((MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.get(matchedPattern.get())).mask(value));
                } else {
                    this.delegate.stringField(fieldInfo, ((MaskedField)DlsFlsFilterLeafReader.this.maskedFieldsMap.get(matchedPattern.get())).mask(value));
                }
            } else {
                this.delegate.stringField(fieldInfo, value);
            }
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.delegate.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.delegate.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.delegate.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.delegate.doubleField(fieldInfo, value);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class FlsStoredFieldVisitor
    extends StoredFieldVisitor {
        private final StoredFieldVisitor delegate;

        public FlsStoredFieldVisitor(StoredFieldVisitor delegate) {
            this.delegate = delegate;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            if (fieldInfo.name.equals("_source")) {
                try {
                    Map filteredSource = DocReader.json().readObject(value);
                    if (!DlsFlsFilterLeafReader.this.canOptimize) {
                        filteredSource = (Map)DlsFlsFilterLeafReader.this.filterFunction.apply(filteredSource);
                    } else if (!DlsFlsFilterLeafReader.this.excludesSet.isEmpty()) {
                        filteredSource.keySet().removeAll(DlsFlsFilterLeafReader.this.excludesSet);
                    } else {
                        filteredSource.keySet().retainAll(DlsFlsFilterLeafReader.this.includesSet);
                    }
                    this.delegate.binaryField(fieldInfo, DocWriter.json().writeAsBytes((Object)filteredSource));
                }
                catch (DocumentParseException | UnexpectedDocumentStructureException e) {
                    throw new ElasticsearchException("Cannot filter source of document", e, new Object[0]);
                }
            } else {
                this.delegate.binaryField(fieldInfo, value);
            }
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return DlsFlsFilterLeafReader.this.isFls(fieldInfo.name) ? this.delegate.needsField(fieldInfo) : StoredFieldVisitor.Status.NO;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.delegate.stringField(fieldInfo, value);
        }

        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.delegate.intField(fieldInfo, value);
        }

        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.delegate.longField(fieldInfo, value);
        }

        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.delegate.floatField(fieldInfo, value);
        }

        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.delegate.doubleField(fieldInfo, value);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    static class DlsFlsDirectoryReader
    extends FilterDirectoryReader {
        private final Set<String> includes;
        private final Query dlsQuery;
        private final IndexService indexService;
        private final ThreadContext threadContext;
        private final ClusterService clusterService;
        private final DlsFlsComplianceConfig complianceConfig;
        private final AuditLog auditlog;
        private final Set<String> maskedFields;
        private final ShardId shardId;

        public DlsFlsDirectoryReader(DirectoryReader in, Set<String> includes, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, DlsFlsComplianceConfig complianceConfig, AuditLog auditlog, Set<String> maskedFields, ShardId shardId) throws IOException {
            super(in, (FilterDirectoryReader.SubReaderWrapper)new DlsFlsSubReaderWrapper(includes, dlsQuery, indexService, threadContext, clusterService, complianceConfig, auditlog, maskedFields, shardId));
            this.includes = includes;
            this.dlsQuery = dlsQuery;
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.clusterService = clusterService;
            this.complianceConfig = complianceConfig;
            this.auditlog = auditlog;
            this.maskedFields = maskedFields;
            this.shardId = shardId;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new DlsFlsDirectoryReader(in, this.includes, this.dlsQuery, this.indexService, this.threadContext, this.clusterService, this.complianceConfig, this.auditlog, this.maskedFields, this.shardId);
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private static class DlsFlsSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final Set<String> includes;
        private final Query dlsQuery;
        private final IndexService indexService;
        private final ThreadContext threadContext;
        private final ClusterService clusterService;
        private final DlsFlsComplianceConfig complianceConfig;
        private final AuditLog auditlog;
        private final Set<String> maskedFields;
        private final ShardId shardId;

        public DlsFlsSubReaderWrapper(Set<String> includes, Query dlsQuery, IndexService indexService, ThreadContext threadContext, ClusterService clusterService, DlsFlsComplianceConfig complianceConfig, AuditLog auditlog, Set<String> maskedFields, ShardId shardId) {
            this.includes = includes;
            this.dlsQuery = dlsQuery;
            this.indexService = indexService;
            this.threadContext = threadContext;
            this.clusterService = clusterService;
            this.complianceConfig = complianceConfig;
            this.auditlog = auditlog;
            this.maskedFields = maskedFields;
            this.shardId = shardId;
        }

        public LeafReader wrap(LeafReader reader) {
            return new DlsFlsFilterLeafReader(reader, this.includes, this.dlsQuery, this.indexService, this.threadContext, this.clusterService, this.complianceConfig, this.auditlog, this.maskedFields, this.shardId);
        }
    }

    private class DlsGetEvaluator {
        private final Bits liveBits;
        private final int numDocs;
        private final IndexReader.CacheHelper readerCacheHelper;
        private final boolean hasDeletions;

        public DlsGetEvaluator(Query dlsQuery, LeafReader in, boolean applyDlsHere) throws IOException {
            if (dlsQuery != null && applyDlsHere) {
                IndexSearcher searcher = new IndexSearcher((IndexReader)DlsFlsFilterLeafReader.this);
                searcher.setQueryCache(null);
                Weight preserveWeight = searcher.createWeight(dlsQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                int maxDoc = in.maxDoc();
                FixedBitSet bits = new FixedBitSet(maxDoc);
                Scorer preserveScorer = preserveWeight.scorer(DlsFlsFilterLeafReader.this.getContext());
                if (preserveScorer != null) {
                    bits.or(preserveScorer.iterator());
                }
                if (in.hasDeletions()) {
                    Bits oldLiveDocs = in.getLiveDocs();
                    assert (oldLiveDocs != null);
                    BitSetIterator it = new BitSetIterator((BitSet)bits, 0L);
                    int i = it.nextDoc();
                    while (i != Integer.MAX_VALUE) {
                        if (!oldLiveDocs.get(i)) {
                            bits.clear(i);
                        }
                        i = it.nextDoc();
                    }
                }
                this.liveBits = bits;
                this.numDocs = in.numDocs();
                this.readerCacheHelper = null;
                this.hasDeletions = true;
            } else {
                this.liveBits = in.getLiveDocs();
                this.numDocs = in.numDocs();
                this.readerCacheHelper = in.getReaderCacheHelper();
                this.hasDeletions = in.hasDeletions();
            }
        }

        public Bits getLiveDocs() {
            return this.liveBits;
        }

        public int numDocs() {
            return this.numDocs;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.readerCacheHelper;
        }

        public boolean hasDeletions() {
            return this.hasDeletions;
        }
    }
}

